#include "vertexBufferObject.h"

// ----------------------------------------------------------------------------------------------------------------------------

CBuffer::CBuffer()
{
	Buffer = NULL;
	BufferSize = 0;
	Position = 0;
}

CBuffer::~CBuffer()
{
	Empty();
}

void *CBuffer::GetData()
{
	return Buffer;
}

int CBuffer::GetDataSize()
{
	return Position;
}

void CBuffer::AddData(void *Data, int DataSize)
{
	int Remaining = BufferSize - Position;

	if(DataSize > Remaining)
	{
		BYTE *OldBuffer = Buffer;
		int OldBufferSize = BufferSize;

		BufferSize += max(1024, DataSize - Remaining);

		Buffer = new BYTE[BufferSize];

		memcpy(Buffer, OldBuffer, OldBufferSize);

		delete [] OldBuffer;
	}

	memcpy(Buffer + Position, Data, DataSize);

	Position += DataSize;
}

void CBuffer::Empty()
{
	delete [] Buffer;

	Buffer = NULL;
	BufferSize = 0;
	Position = 0;
}
